<?php

/**
 * This is the model class for table "FormularzUzytkownika".
 *
 * The followings are the available columns in table 'FormularzUzytkownika':
 * @property double $id
 * @property double $idFormularza
 * @property double $idUzytkownika
 * @property double $status
 * @property string $dataModyfikacji
 */
class FormularzUzytkownika extends CActiveRecord
{
	const STATUS_DRAFT = 0;
	const STATUS_FILLED = 1;
	const STATUS_ACCEPTED = 2;
	const STATUS_REFUSED = 3;

	public static $statusName = array(
		self::STATUS_DRAFT => 'Szkic',
		self::STATUS_FILLED => 'Wypełniony',
		self::STATUS_ACCEPTED => 'Zaakceptowany',
		self::STATUS_REFUSED => 'Odrzucony',
	);

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return FormularzUzytkownika the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'FormularzUzytkownika';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('id, idFormularza, idUzytkownika, status', 'numerical'),
			array('dataModyfikacji', 'safe'),

			array('id, idFormularza, idUzytkownika, status, dataModyfikacji', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'formularz'=>array(self::BELONGS_TO, 'Formularz', 'idFormularza'),
			'dane'=>array(self::HAS_MANY, 'FormularzDane', 'idFormularzaUzytkownika'),
			'uzytkownik'=>array(self::BELONGS_TO, 'Uzytkownik', 'idUzytkownika')
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('FormularzUzytkownika', 'id'),
			'idFormularza'=>Yii::t('FormularzUzytkownika', 'idFormularza'),
			'idUzytkownika'=>Yii::t('FormularzUzytkownika', 'idUzytkownika'),
			'status'=>Yii::t('FormularzUzytkownika', 'status'),
			'dataModyfikacji'=>Yii::t('FormularzUzytkownika', 'dataModyfikacji'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('idFormularza', $this->idFormularza);
		$criteria->compare('idUzytkownika', $this->idUzytkownika);
		$criteria->compare('status', $this->status);
		$criteria->compare('dataModyfikacji', $this->dataModyfikacji, true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public function getStatusName()
	{
		return self::$statusName[$this->status];
	}

	public static function getTeacherUserForm($userFormId)
	{
		return FormularzUzytkownika::model()->find(array(
			'join' => '
				LEFT JOIN "Uzytkownik" "u" ON "u"."id" = "t"."idUzytkownika"
				LEFT JOIN "AdminKlasy" "ak" ON "ak"."idKlasy" = "u"."idKlasy"',
			'condition' => '"t"."id" = :userFormId AND "ak"."idAdmina" = :teacherId',
			'params' => array(
				':userFormId' => $userFormId,
				':teacherId' => Yii::app()->user->id
			)
		));
	}
}